/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.PortMapWidget;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8275.BoxInfo;
import ibm.nways.jdm8275.eui.ConfigurationAlternateGroup;
import ibm.nways.jdm8275.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8275.eui.FaultFolderGroup;
import ibm.nways.jdm8275.eui.SecurityFolderGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rmon.RmonContext;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.telnet.TelnetPanel;
import ibm.nways.web.WebBrowserGroup;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class Jdm8275
extends JdmBrowser {
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    private static String bundleName = "ibm.nways.jdm8275.GeneralResources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private BoxInfo boxInfo;
    public boolean loggingOn = false;
    private NavFieldOverride jdm8275Overrides;
    static final Object[][] allModelsOverrides = new Object[][]{{"ibm.nways.mib2.model.System.Panel.SysDescr.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysContact.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysName.length", "48"}, {"ibm.nways.mib2.model.System.Panel.SysLocation.length", "48"}, {"ibm.nways.mib2.eui.Mib2InterfacesPanel.rfc1573.visible", "false"}, {"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteProto.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteInfo.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}};
    static final Object[][] bbI_Overrides = new Object[][]{{"ibm.nways.jdm8275.model.AgentAccess.Panel.ConsoleLogoutInterval.access", "not-supported"}, {"ibm.nways.jdm8275.model.UpdateDev.Panel.Sw2TftpDownloadPort.access", "not-supported"}, {"ibm.nways.jdm8275.model.Version.Panel.Sw2BaseHwVer.access", "not-supported"}};
    static final Object[][] bbI_version1_Overrides = new Object[][]{{"ibm.nways.jdm8275.eui.AgentAccessPanel.AgentAccessDetail.visible", "false"}, {"ibm.nways.jdm8275.eui.UpdateDevPanel.ConfigurationSection.visible", "false"}};
    static final Object[][] bbII_Overrides = new Object[][]{{"ibm.nways.jdm8275.model.UpdateDev.Panel.SwTftpDownloadPort.access", "not-supported"}, {"ibm.nways.jdm8275.model.Version.Panel.SwBaseHwVer.access", "not-supported"}};
    static final Object[][] bbII_217_Overrides = new Object[][]{{"ibm.nways.jdm8275.eui.TrunkGroupPanel.Sw2TrunkGroupDetailsB.visible", "false"}};
    static final Object[][] bbII_225_Overrides = new Object[][]{{"ibm.nways.jdm8275.eui.TrunkGroupPanel.Sw2TrunkGroupDetailsA.visible", "false"}};

    public String getModelTypeName() {
        return "ibm.nways.jdm8275.model.Jdm8275";
    }

    public Dimension getDefaultSize() {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = "getNavTreeRoot";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        if (this.deviceModel != null || this.boxInfo != null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "Redraw request but still needed to call dispose");
            }
            this.dispose();
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            this.rootFolder = new NavigationFolder(this.getNLSString("unknownDevice"));
            this.navContext = this.rootFolder.getNavContext();
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "deviceModel is NULL!");
                RAS.exit(19, 7, (Object)this, string);
            }
            return this.rootFolder;
        }
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.rootFolder = this.boxInfo.getDeviceStatus() == 1 ? new NavigationFolder(this.getNLSString("deviceName")) : new NavigationFolder(this.getNLSString("unknownDevice"));
        this.navContext = this.rootFolder.getNavContext();
        BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        this.jdm8275Overrides = new NavFieldOverride(this.navContext, allModelsOverrides);
        switch (this.boxInfo.getDeviceType()) {
            case 1: {
                this.addOverrides(this.jdm8275Overrides, bbI_Overrides);
                if (this.boxInfo.getAgentVersion() != 1) break;
                this.addOverrides(this.jdm8275Overrides, bbI_version1_Overrides);
                break;
            }
            case 2: {
                this.addOverrides(this.jdm8275Overrides, bbII_Overrides);
                this.addOverrides(this.jdm8275Overrides, bbII_217_Overrides);
                break;
            }
            case 3: {
                this.addOverrides(this.jdm8275Overrides, bbII_Overrides);
                this.addOverrides(this.jdm8275Overrides, bbII_225_Overrides);
                break;
            }
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
        return this.rootFolder;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        String string = "getDeviceGraphicPanel";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        long l = System.currentTimeMillis();
        if (this.deviceModel != null) {
            this.displayMsg(this.getNLSString("StartGraphic"));
            graphicPanel = this.boxInfo.getDeviceGraphic();
            this.displayMsg(this.getNLSString("EndGraphic"));
        } else {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "Can't draw graphic");
            }
            GraphicContainer graphicContainer = new GraphicContainer();
            Label label = new Label(this.getNLSString("NoGraphic"), 1);
            label.setFont(new Font("Arial", 1, 14));
            label.setLocation(new Point(35, -5));
            graphicContainer.add(label);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, (Object)this, string, " Finished device picture in " + String.valueOf(l2 - l) + " msecs");
            RAS.exit(19, 7, (Object)this, string);
        }
        return graphicPanel;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        this.displayMsg(this.getNLSString("StartNavTree"));
        long l = System.currentTimeMillis();
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[]{1};
        RmonContext rmonContext = new RmonContext(nArray2, nArray3, nArray4);
        this.navContext.put((Object)"rmonContext", (Object)rmonContext);
        if (this.deviceModel != null && (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 3)) {
            this.buildConfiguration(this.rootFolder);
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "Built full nav tree.");
            }
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            hashtable.put("MaxPorts", new Integer(this.boxInfo.getCurrentNumOfPorts()));
            hashtable.put("Columns", new Integer(5));
            PortMapWidget.setWidgetOverrides((NavigationContext)this.navContext, hashtable);
        } else {
            this.buildAltConfigurationFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "Built partial nav tree.");
            }
        }
        this.displayMsg(this.getNLSString("EndNavTree"));
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 7)) {
            RAS.trace(19, 7, (Object)this, string, "Completed Navigation Tree in " + String.valueOf(l2 - l) + " msecs");
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        if (this.boxInfo != null) {
            this.boxInfo.dispose();
            this.boxInfo = null;
        }
        this.rootFolder = null;
        this.tree = null;
        this.navContext = null;
        this.jdm8275Overrides = null;
        this.deviceModel = null;
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    protected String getNLSString(String string) {
        String string2 = null;
        String string3 = "getNLSString";
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
                RAS.trace(19, 7, (Object)this, string3, "No NLS translation for string " + string);
            }
        }
        return string2;
    }

    private void buildConfiguration(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildConfiguration";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Configuration");
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, (Object)this, string, "Missing full Configuration Folder -Exception getting config Model");
            }
            RAS.logException(19, 7, (Object)this, string, exception);
            this.buildAltConfigurationFolder(navigationFolder);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    private void buildAltConfigurationFolder(NavigationFolder navigationFolder) {
        String string = "buildAltConfigurationFolder";
        GenModel genModel = null;
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigALT");
        }
        catch (Exception exception) {
            RAS.logException(19, 7, (Object)this, string, exception);
            genModel = this.deviceModel;
        }
        if (genModel == null) {
            genModel = this.deviceModel;
        }
        ConfigurationAlternateGroup configurationAlternateGroup = new ConfigurationAlternateGroup((JdmBrowser)this, genModel);
        this.tree.addEventListener((NavigationBrowserEventListener)configurationAlternateGroup);
        configurationAlternateGroup.setIsInitiallyExpanded(false);
        navigationFolder.add((NavigationPoint)configurationAlternateGroup);
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildFaultFolder";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("FaultFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 7, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultFolderGroup faultFolderGroup = new FaultFolderGroup((JdmBrowser)this, genModel);
            faultFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultFolderGroup);
            navigationFolder.add((NavigationPoint)faultFolderGroup);
        } else {
            navigationFolder.add((NavigationPoint)new NavigationItem(this.getNLSString("Fault"), (NavigationDestination)new MessageDestination(this.getNLSString("NotConfigured"))));
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildSecurityFolder";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("SecurityFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 7, (Object)this, string, exception);
        }
        if (genModel != null) {
            SecurityFolderGroup securityFolderGroup = new SecurityFolderGroup((JdmBrowser)this, genModel);
            securityFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityFolderGroup);
            navigationFolder.add((NavigationPoint)securityFolderGroup);
        } else {
            navigationFolder.add((NavigationPoint)new NavigationItem(this.getNLSString("Security"), (NavigationDestination)new MessageDestination(this.getNLSString("NotConfigured"))));
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        String string;
        block4: {
            NavigationFolder navigationFolder2 = new NavigationFolder(this.getNLSString("ToolsGroupTitle"));
            NavigationContext navigationContext = null;
            SnmpContextModel snmpContextModel = null;
            String string2 = null;
            string = "buildToolsFolder";
            navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.setIsInitiallyExpanded(true);
            navigationFolder.add((NavigationPoint)navigationFolder2);
            try {
                WebBrowserGroup webBrowserGroup;
                WebContext webContext;
                snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
                ModelInfo modelInfo = snmpContextModel.getConfig();
                string2 = modelInfo.get("Config.Address").toString();
                TelnetContext telnetContext = new TelnetContext(string2);
                NavigationItem navigationItem = new NavigationItem(TelnetPanel.getTitle(), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
                navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"telnetContext", (Object)telnetContext);
                navigationFolder2.add((NavigationPoint)navigationItem);
                NavigationBrowser navigationBrowser = this.getNavigationBrowser();
                Browser browser = new Browser(this.getNLSString("MibBrowserTitle"), (JdmBrowser)this, snmpContextModel);
                navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
                navigationFolder2.add((NavigationPoint)browser.getRootFolder());
                if (this.getIsApplication()) {
                    webContext = new AnalyzerJdmContext(string2, this.getServerPortNumber());
                    webBrowserGroup = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                    navigationContext = webBrowserGroup.getNavContext();
                    navigationContext.put((Object)"analyzerJdmContext", (Object)webContext);
                    navigationFolder2.add((NavigationPoint)webBrowserGroup);
                }
                webContext = new WebContext(string2);
                webContext.support_and_device();
                webBrowserGroup = new WebBrowserGroup(webContext);
                webBrowserGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
                webBrowserGroup.setIsInitiallyExpanded(false);
                navigationBrowser.addEventListener((NavigationBrowserEventListener)webBrowserGroup);
                navigationFolder2.add((NavigationPoint)webBrowserGroup);
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 7)) break block4;
                RAS.trace(19, 7, (Object)this, string, "Can't build dependent folders");
                RAS.logException(19, 7, (Object)this, string, exception);
            }
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, (Object)this, string);
        }
    }

    private void addOverrides(NavFieldOverride navFieldOverride, Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            navFieldOverride.put(objectArray[n][0], objectArray[n][1]);
            ++n;
        }
    }
}

